<?php
/*                                                                                                                                               
                     ':                                                                                                                       ':                       
                    '''                                                                                                                      ;''                       
                     ',                                                                                                                       ':                       
                      ;''                                                                                                                  .''                         
                     .''':                                                                                                                 ''''                        
                     :''';                                                                                                                 ''''                        
                      '''                                                                                                                  ''',                        
                       ` ,;`                                                                                                             :: `                          
                        '''''                                                                                                          `'''',                          
                       ''''''                                                                                                          ''''''                          
                       ''''''.                                                                                                         ''''''                          
                       ''''''`  ;'';                                                                                            .'''`  ''''''                          
                        '''''  ''''''                                                                                          :'''''` .'''';                          
                         ;',  :'''''',                                                                                         '''''''   ;'.                           
                              ''''''''                                                                                        `'''''''                                 
                        `,    ''''''''                                                                                        `'''''''    ..                           
                       '''''  .''''''.                                                                                         '''''''  .'''':                         
                      '''''';  ''''';                                                                                          `'''''   ''''''.                        
                     `'''''''   `;:`                                                                                             ,;,   ;'''''''                        
                     ,'''''''                                                                                                          ''''''''                        
                      '''''''                                                                                                          ,'''''''                        
                      ''''''.                                                                                                           ''''''                         
                       ;'''.                                                                                                             ''''                          
                         '@@      `@@       @@@@@@@@@@@ #@@@@#'.                 @@@@@@@@@@@@@@@@@@@@@@@@@    ,@@@@@@@+.   '@@        +@@                              
                    ;''''`@@      '@@,      @@@@@@@@@@@ @@@@@@@@@                @@@@@@@@@@@@@@@@@@@@@@@@@  `@@@@@@@@@@@   '@@        +@@  '''',                       
                   ;''''''@@`     @@@#     .@#       @@ @@@  `#@@@                     ;@@             @@@ `@@@`     `+@   '@@        +@@ ''''''`                      
                   '''''''@@+     @@@@     #@.       @@ @@@    ;@@`                    ;@@             @@@ @@@             '@@        +@@,'''''''                      
                   '''''''+@@     @#@@     @@        @@ @@@     @@.      `.            ;@@             @@@+@@              '@@        +@@;'''''''                      
                   '''''''`@@    :@.@@`    @@        @@ @@@     @@      @@@@+          ;@@             @@@@@@              '@@        +@@,'''''''                      
             ;'''  ;'''''' @@.   @@ @@'   ;@;        @@ @@@    +@@     @@  +@          ;@@             @@@@@,              '@@        +@@ ''''''.  :':                 
    :, :''' ;'''''  ;''''  @@#   @@ +@@   @@         @@ @@@   '@@      @@  .@          ;@@             @@@@@               '@@        +@@  '''',  '''''  .'.           
   .'' '''' ''''''         '@@   @# .@@   @@  :@@@@@@@@ @@@@@@@;       #@  @@          ;@@       @@@@@@@@@@@               '@@@@@@@@@@@@@        :''''':.'''. ':       
    '' '''' ''''''         `@@  ,@,  @@  .@#  :@@@@@@@@ @@@@@@@@,       @#@@           ;@@       @@@@@@@@@@@               '@@++++++++@@@        ''''''';''';'''       
       `''. ''''''   .,`    @@. #@   @@: #@,         @@ @@@   :@@@     @@@+            ;@@             @@@@@               '@@        +@@   .,   ,''''',`'''` ',       
             ''''  `'''''   @@# @@   @@@ @@          @@ @@@     @@'  `@# @@   @@       ;@@             @@@@@.              '@@        +@@ .'''';  '''''  `:`           
                   '''''':  ;@@ @@   :@@ @@          @@ @@@     @@@  @@  ;@;  @@       ;@@             @@#@@#              '@@        +@@ '''''',  .;.                 
                  ,'''''''   @@.@;    @@:@'          @@ @@@     '@@  @'   @@  @@       ;@@             @@@@@@              '@@        +@@:'''''''                      
                  :'''''''   @@@@     @@@@`          @@ @@@     @@@  @+    @@ @`       ;@@             @@@.@@@             '@@        +@@;'''''''                      
                  `'''''''   @@@@     @@@@           @@ @@@    :@@@  @@    .@@@        ;@@             @@@ @@@@       .@   '@@        +@@.'''''''                      
                   ''''''    ;@@@     '@@@   @@@@@@@@@@ @@@@@@@@@@   :@@   .@@#        ;@@     #@@@@@@@@@@  @@@@@';'@@@@   '@@        +@@ ''''''                       
                    ;'''`     @@'     `@@:   @@@@@@@@@@ @@@@@@@@#     :@@@@@'@@'       ;@@     #@@@@@@@@@@   ,@@@@@@@@@    '@@        +@@  ''''                        
                        `'':                                             `                     ;           ,`   `,:.                   .,                              
                       ,'''''                                                                  ;        @                            ,'''';                            
                       '''''''                                                       @#@  ##@  ;  @  @ @@@ ;` `@@;  @+@'  @#'        ''''''.                           
                      .'''''''                                                       #   ;,  @ ;  @  @  @  ;` @  #  @  @ `;         ;'''''''                           
                      .'''''''                                                       +@` #   @ ;  @  @  @  ;` @  ;, @  @  #@        ''''''''                           
                       '''''''   `,.                                                   @ +`  @ ;  @  @  @  ;` @  +` @  @    @       ,'''''''                           
                       ,'''''   '''''                                                ;,@  @.@` ;  @;@@  @. ;` +':@  @  @ .::#.''''   ''''''                            
                        `'';   '''''''                                                                                      `''''''   ''''                             
                               '''''''                                                                                      ''''''',                                   
                          `    '''''''`                                                                                     ''''''';                                   
                        ;''';  '''''''                                                                                      ''''''':  ''''                             
                       `'''''` ,''''';                                                                                      `''''''  ''''''                            
                       ;''''';  .''',                                                                                        ,''''   ''''''                            
                       ;''''';                                                                                                       ''''''                            
                        '''''                                                                                                        ''''''                            
                        `'''`                                                                                                         ''''                             
                     `'''                                                                                                                 '':                          
                     ''''`                                                                                                               ''''                          
                     ''''                                                                                                                ''''                          
                      '';                                                                                                                .'''                          
                    ''                                                                                                                      `'                         
                   `''`                                                                                                                     '''                        
                    ;;                                                                                                                      :'.                                                                                                                                               
 */
/**
 * Classe per l'invio di mail in PHP
 * Sviluppata da Web & Tech Solutions
 *
 * @author Luciano Alex <alex.luciano@wt-solutions.it>
 * @version 1.1
 */
class myMail {
    private $dest="";
    
    function __construct($mailDest) {
       $this->dest = $mailDest;
   }
   /**
    * Invia una mail al destinatario in formato testo
    * @param String $mittente  Identifica il mittente della mail che verra inviata
    * @param String $oggetto   Identifica l'oggetto del messaggio 
    * @param String $messaggio Messaggio che verra inviato
    * @return Boolean Restituisce true se l'invio e andato a buon fine, false altrimenti
    **/
   function sendTextMail($mittente,$oggetto,$messaggio){
       $headers = 'From: ' .$mittente . "\r\n" .
                  'Reply-To: ' .$mittente . "\r\n" .
                  'X-Mailer: PHP/' . phpversion();
       return mail($this->dest, $oggetto, $messaggio, $headers);
   }
   
    /**
    * Invia una mail al destinatario in formato HTML (Senza allegato)
    * @param String $mittente  Identifica il mittente della mail che verra inviata
    * @param String $oggetto   Identifica l'oggetto del messaggio 
    * @param String $messaggio Messaggio che verra inviato
     * @return Boolean Restituisce true se l'invio e andato a buon fine, false altrimenti
    **/
   function sendHTMLMail($mittente,$oggetto,$messaggio){
       $headers = "From: " . strip_tags($mittente) . "\r\n";
       $headers .= "Reply-To: ". strip_tags($mittente) . "\r\n";
    //   $headers .= "CC: susan@example.com\r\n";
       $headers .= "MIME-Version: 1.0\r\n";
       $headers .= "Content-Type: text/html; charset=utf-8\r\n";
       
       return mail($this->dest, $oggetto, $messaggio, $headers);
   }
   
   /**
    * Invia una mail al destinatario in formato HTML con allegato 
    * @param String $mittente  Identifica il mittente della mail che verra inviata
    * @param String $oggetto   Identifica l'oggetto del messaggio 
    * @param String $messaggio Messaggio che verra inviato
    * @param String $allegato il file allegato da inviare alla mail
    * @return Boolean Restituisce true se l'invio e andato a buon fine, false altrimenti
    **/
   function sendHTMLMailWithAttach($mittente,$oggetto,$messaggio,$allegato){
        $headers = "From: ".$mittente;
        $random_hash = md5(date('r', time()));
        $headers .= "\r\nContent-Type: multipart/mixed; boundary=\"PHP-mixed-".$random_hash."\"";		
        $attachment = chunk_split(base64_encode(file_get_contents($allegato["tmp_name"]))); // Set your file path here
        //define the body of the message.
        $message = "--PHP-mixed-$random_hash\r\n"."Content-Type: multipart/alternative; boundary=\"PHP-alt-$random_hash\"\r\n\r\n";
        $message .= "--PHP-alt-$random_hash\r\n"."Content-Type: text/plain; charset=\"iso-8859-1\"\r\n"."Content-Transfer-Encoding: 7bit\r\n\r\n";
        //Insert the html message.
        $message .= $messaggio;
        $message .="\r\n\r\n--PHP-alt-$random_hash--\r\n\r\n";
        //include attachment
        $message .= "--PHP-mixed-$random_hash\r\n"."Content-Type: application/zip; name=\"".$allegato["name"]."\"\r\n"."Content-Transfer-Encoding: base64\r\n"."Content-Disposition: attachment\r\n\r\n";
        $message .= $attachment;
        $message .= "/r/n--PHP-mixed-$random_hash--";
                    //send the email
         return mail( $this->dest, $oggetto , $message, $headers );
   }
   
}
